<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Instruktur;
use App\Models\Personal;
use App\Models\Member;
use App\Models\Fee;
use Carbon\Carbon;
use Redirect,Response;
class FeeController extends Controller
{
    public function index()
    {
        $today=Carbon::now()->format('d-m-Y');
        $ins = Personal::all();
        $fee = Fee::all();
        return view('fee.index', compact('ins','today','fee'));
    }

    public function data()
    {
         
        $fee = Fee::leftJoin('instruktur', 'instruktur.id_instruktur', 'fee_marketing.id_instruktur')
        ->select('fee_marketing.*', 'nama_instruktur')
        // ->orderBy('kode_produk', 'asc')
        ->get(); 
        return datatables()
        ->of($fee)
        ->addIndexColumn()
        ->addColumn('select_all', function ($fee) {
            
            return '
                <input type="checkbox" name="id[]" value="'. $fee->id .'">
            ';
            
        })
         ->addColumn('persen', function ($fee) {
            return ($fee->persen).'%';
        })
        ->addColumn('fee', function ($fee) {
            return format_uang($fee->fee);
        })
        ->addColumn('omzet', function ($fee) {
            return format_uang($fee->omzet);
        })
        ->addColumn('aksi', function ($fee) {
            return '
            <div class="btn-group">
                <button type="button" onclick="deleteData(`'. route('fee.destroy', $fee->id) .'`)" class="btn btn-xs btn-danger btn-flat"><i class="fa fa-trash"></i></button>
            </div>
            ';
        })
        ->rawColumns(['aksi', 'kode_produk', 'select_all'])
        ->make(true);
    }

    public function fee_ambilData(Request $request)
    {
        if(!$request->ajax()) abort(404);
        $hasil = [];
        $id_instruktur = intval($request->get('layanan_id'));

        $total = Member::whereRaw('MONTH(tgl_masuk) = MONTH(NOW())')
                        ->whereRaw('YEAR(tgl_masuk) = YEAR(NOW())')
                        ->where('id_instruktur' ,$id_instruktur)
                        ->sum('harga');
        $hasil = $total;
        return Response::json($hasil);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $fee = Fee::latest()->first() ?? new Fee();
        // $request['kode_member'] = 'K'. tambah_nol_didepan((int)$member->id_member +1, 6);

        $fee = Fee::create($request->all());
        // dd($member->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        // $fee = Fee::find($id);

        // return response()->json($fee);
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $fee = Fee::find($id)->update($request->all());

        return response()->json('Data berhasil disimpan', 200);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $fee = Fee::find($id);
        $fee->delete();

        return response(null, 204);
    }
    public function deleteSelected(Request $request)
    {
        foreach ($request->id as $id) {
            $fee = Fee::find($id);
            $fee->delete();
        }

        return response(null, 204);
    }
    // public function cetakMember(Request $request)
    // {
    //     $datamember = collect(array());
    //     foreach ($request->id_member as $id) {
    //         $member = Member::find($id);
    //         $datamember[] = $member;
    //     }

    //     $datamember = $datamember->chunk(2);
    //     $setting    = Setting::first();

    //     $no  = 1;
    //     $pdf = PDF::loadView('member.cetak', compact('datamember', 'no', 'setting'));
    //     $pdf->setPaper(array(0, 0, 566.93, 850.39), 'potrait');
    //     return $pdf->stream('member.pdf');
    // }
}
